function obj=set(obj,varargin)
% SET retourne un nouvel objet informatique marche obtenu en modifiant une ou plusieurs
%   valeurs des proprits d'un ancien objet marche.
%   obj=SET(obj,proprit1,valeur1,proprit2, valeur2, ...)
%       >> obj          = objet informatique marche;
%       >> proprit    = proprit de la marche;
%       >> valeur       = valeur de la proprit.
%   Proprit   = 'Nom','Position','EnergiePotentielleEntree','EnergiePotentielleSortie',
%                 'VecteurOndeEntree', 'VecteurOndeSortie'.
%       << obj          = nouvel objet informatique marche.
%
%   Olivier Pujol : septembre 2013
%
%%
prop_argin=varargin;
while length(prop_argin)>=2
    property=prop_argin{1};
    value=prop_argin{2};
    prop_argin=prop_argin(3:end);
    switch property
        case 'Nom'
            obj.name=value;
        case 'Position'
            obj.x=value;
        case 'EnergiePotentielleEntree'
            obj.Epe=value;
        case 'EnergiePotentielleSortie'
            obj.Eps=value;
        case 'VecteurOndeEntree'
            obj.ke=value;
        case 'VecteurOndeSortie'
            obj.ks=value;
        otherwise
            error([property,' n''est pas une proprit de la marche !']);
    end
end
%
return;